<?php
/**
 * Avalanche for Magento 1.8+
 * Designed by Fast Division (http://fastdivision.com)
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the EULA
 * that is bundled with this package in the file license.txt.
 * It is also available through the world-wide-web at this URL:
 * http://fastdivision.com/legal/license.txt
 *
 * @author     Fast Division
 * @version    1.5.0
 * @copyright  Copyright 2013 Fast Division
 * @license    http://fastdivision.com/legal/license.txt
 */
class FastDivision_Navigation_Model_Navigation extends Mage_Core_Model_Abstract
{
   private $_topLevelItems = array();

   public function _construct()
   {
      parent::_construct();
      $this->_init('navigation/navigation');
   }
   
   public function getItemsData($storeId)
   {
      $resource = Mage::getSingleton('core/resource');
      $read = $resource->getConnection('core_read');
      $navTable = $resource->getTableName('navigation');

      $select = $read->select()
         ->from($navTable, array('*'))
         ->where('status = ?', 1)
         ->where('store_id = ?', 0)
         ->orWhere('store_id = ?', $storeId)
         ->order('i_index ASC');

      return $read->fetchAll($select);
   }
   
   public function getBlockIdentifierByBlockId($id)
   {
      $resource = Mage::getSingleton('core/resource');
      $read = $resource->getConnection('core_read');
      $select = $read->select()->from($resource->getTableName('cms_block'), array(
         'block_id','identifier'))->where('block_id = ?', $id);
      $result = $read->fetchRow($select);
      
      return array_key_exists('identifier', $result) ? $result['identifier'] : '';
   }

   public function getCurrentStore()
   {
      return Mage::app()->getStore();
   }
}